/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.sever;

import cn.com.duiba.kjy.base.customweb.sever.NettyServerConfigurationProperties;
import cn.com.duiba.kjy.base.customweb.sever.ServerChannelInitializer;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;

public class CustomNettyServer
implements WebServer {
    private static final Logger log = LoggerFactory.getLogger(CustomNettyServer.class);
    private final ServerBootstrap nettyServer;
    private final NettyServerConfigurationProperties nettyConfig;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workGroup;
    private final DispatcherHandler dispatcherHandler;
    private final ExceptionChain exceptionChain;
    private ChannelFuture channelFuture;

    public CustomNettyServer(NettyServerConfigurationProperties nettyConfig, EventLoopGroup bossGroup, EventLoopGroup workGroup, DispatcherHandler dispatcherHandler, ExceptionChain exceptionChain) {
        this.dispatcherHandler = dispatcherHandler;
        this.nettyServer = new ServerBootstrap();
        this.nettyConfig = nettyConfig;
        this.bossGroup = bossGroup;
        this.workGroup = workGroup;
        this.exceptionChain = exceptionChain;
    }

    public void start() throws WebServerException {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.nettyServer.group(this.bossGroup, this.workGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.SO_RCVBUF, (Object)32768)).childHandler((ChannelHandler)new ServerChannelInitializer(this.dispatcherHandler, this.exceptionChain)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.channelFuture = this.nettyServer.bind(this.nettyConfig.getPort()).addListener(channelFuture -> {
            if (channelFuture.isSuccess()) {
                log.info("\u670d\u52a1\u7aef\u542f\u52a8\u6210\u529f port = {}", (Object)this.nettyConfig.getPort());
            } else {
                log.info("\u670d\u52a1\u7aef\u542f\u52a8\u5931\u8d25 port = {}", (Object)this.nettyConfig.getPort());
            }
        });
        try {
            this.channelFuture.sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void stop() throws WebServerException {
        this.channelFuture.channel().close().addListener(channelFuture -> log.info("netty server shout down successful!"));
    }

    public int getPort() {
        return this.nettyConfig.getPort();
    }
}

