/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.util;

import io.netty.handler.codec.http.FullHttpRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlHelper {
    private static final Logger log = LoggerFactory.getLogger(UrlHelper.class);

    public static URI decodeAndCleanUriString(FullHttpRequest request) {
        String uri = request.uri();
        uri = UrlHelper.removeSemicolonContentInternal(uri);
        UrlHelper.decode(uri);
        uri = UrlHelper.getSanitizedPath(uri);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            log.warn("\u975e\u6cd5\u7684URI\uff1a{}", (Object)uri, (Object)e);
            return null;
        }
    }

    private static String decode(String source) {
        try {
            return URLDecoder.decode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLDecoder.decode(source);
        }
    }

    private static String removeSemicolonContentInternal(String requestUri) {
        int semicolonIndex = requestUri.indexOf(59);
        while (semicolonIndex != -1) {
            int slashIndex = requestUri.indexOf(47, semicolonIndex);
            String start = requestUri.substring(0, semicolonIndex);
            requestUri = slashIndex != -1 ? start + requestUri.substring(slashIndex) : start;
            semicolonIndex = requestUri.indexOf(59, semicolonIndex);
        }
        return requestUri;
    }

    private static String getSanitizedPath(String path) {
        int index;
        String sanitized = path;
        while ((index = sanitized.indexOf("//")) >= 0) {
            sanitized = sanitized.substring(0, index) + sanitized.substring(index + 1);
        }
        return sanitized;
    }
}

