/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.sever.KjjAnnotationConfigApplicationContext;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.CustomFeignClientsRegistrar;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
@ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class KjjRibbonCustomAutoConfiguration {
    @Resource
    private SpringClientFactory springClientFactory;

    @Bean
    public ApplicationListener<ContextRefreshedEvent> kjjSpringClientFactoryInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                if (event.getApplicationContext() instanceof KjjAnnotationConfigApplicationContext) {
                    Set enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames();
                    for (String name : enabledFeignClientNames) {
                        KjjRibbonCustomAutoConfiguration.this.springClientFactory.getClientConfig(name);
                    }
                }
            }
        };
    }
}

