/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.codec.jackson;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.customweb.exception.IllegalIdException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class JacksonIdDeserialization
extends JsonDeserializer {
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (Objects.equals(p.getCurrentTokenId(), 6)) {
            try {
                String valueAsString = p.getValueAsString();
                if (StringUtils.isBlank((String)valueAsString)) {
                    return null;
                }
                Long id = IdMakeUtil.decodingId(valueAsString);
                if (Objects.isNull(id) && StringUtils.isNotBlank((String)valueAsString)) {
                    throw new IllegalIdException();
                }
                return id;
            }
            catch (Exception e) {
                throw new IllegalIdException();
            }
        }
        throw new IllegalIdException();
    }
}

