package cn.com.duiba.kjy.base.api.enums.oa;


import java.util.Objects;

/**
 * 微信各种账号的业务类型。
 * 如需请求带有access_token 参数的接口，请在{@link  cn.com.duiba.kjy.service.accesstoken.RequestTokenHandle}实现中做相对应的处理
 * Created by dugq on 2019-06-01.
 */
public enum OATypeEnum {
    CONTENT_MAIN_OA(1, OaTargetEnum.OA.getCode(), "内容主体公众号") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.OA;
        }
    },
    VIP_OA(2, OaTargetEnum.OA.getCode(), "付费用户的VIP专属公众号") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.VIP;
        }
    },
    MP(3, OaTargetEnum.MP.getCode(), "客集集主体小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.MP;
        }
    },
    LIVE_USER_MP(9, OaTargetEnum.MP.getCode(), "直播用户端") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_USER_MP;
        }
    },

    LIVE_ANCHOR_MP(10, OaTargetEnum.MP.getCode(), "直播管理端") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_ANCHOR_MP;
        }
    },

    OPEN_PL(11, null, "第三方服务平台") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            //暂无用户
            return null;
        }
    },

    OPEN_OA(12, OaTargetEnum.OA.getCode(), "第三方服务平台服务-直播业务的公众号") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_OA;
        }
    },

    OPEN_MP(13, OaTargetEnum.MP.getCode(), "第三方服务平台服务的小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_USER_MP;
        }
    },

    PROXY_LIVE_USER_MP(14, OaTargetEnum.MP.getCode(), "代理直播用户小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_USER_MP;
        }
    },

    LIVE_OA(16, OaTargetEnum.OA.getCode(), "直播公众号") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_OA;
        }
    },

    VIDEO_APP(19, OaTargetEnum.PHONE_APP.getCode(), "短视频APP") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.VIDEO_APP;
        }
    },

    RISK_MP(20, OaTargetEnum.MP.getCode(), "风险测评小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.RISK_MP;
        }
    },

    OPEN_VIP_OA(21, OaTargetEnum.OA.getCode(), "第三方服务平台服务的客集集账号业务的公众号") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            //暂不保存用户
            return UserExtTypeEnum.OA;
        }
    },

    OTO_MP(22, OaTargetEnum.MP.getCode(), "OTO用户小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            //暂不保存用户
            return UserExtTypeEnum.OA;
        }
    },

    OTO_COMPANY_OA(23, OaTargetEnum.OA.getCode(), "OTO不同公司对应的公众号") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            //暂不保存用户
            return UserExtTypeEnum.OA;
        }
    },
    ;
    /**
     * 和 user-service {@link cn.com.duiba.user.service.api.enums.oa.OATypeEnum}同步。
     * 由于历史原因，导致二者不和。但type是一致的
     */
    private final Integer type;
    //1:公众号 2：小程序 3:web应用
    private final Integer target;
    private final String desc;

    OATypeEnum(Integer type, Integer target, String desc) {
        this.type = type;
        this.target = target;
        this.desc = desc;
    }

    public Integer getTarget() {
        return target;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e : values())
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

    public abstract UserExtTypeEnum change2ExtTypeEnum();
}
