package cn.com.duiba.kjy.base.api.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;

/**
 * Created by dugq on 2019-05-05.
 * id集合的序列化.
 *         eg:
 *           @JSONField(serializeUsing =IdFastJsonSerializable.class )
 *           private List<Long> ids;
 *
 *            @JSONField(serializeUsing =IdFastJsonSerializable.class )
 *            private Set<Long> ids;
 */
@Slf4j
public class IdListBase64Serializable extends JsonSerializer<Collection<Long>> {

    @Override
    public void serialize(Collection<Long> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if(Objects.nonNull(value)){
            gen.writeStartArray();
            value.forEach(v->{
                try {
                    gen.writeString(IdMakeUtil.encodingId(v));
                } catch (IOException e) {
                    log.error("写如json报错{}",e);
                }
            });
            gen.writeEndArray();
        }
    }
}
