package cn.com.duiba.kjy.base.customweb.util;

import io.netty.handler.codec.http.FullHttpRequest;
import lombok.extern.slf4j.Slf4j;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;

/**
 * @author dugq
 * @date 2021/4/1 8:00 下午
 */
@Slf4j
public class UrlHelper {


    public static URI decodeAndCleanUriString(FullHttpRequest request) {
        String uri = request.uri();
        uri = removeSemicolonContentInternal(uri);
        decode(uri);
        uri = getSanitizedPath(uri);
        try {
            return new URI(uri);
        } catch (URISyntaxException e) {
            log.warn("非法的URI：{}",uri,e);
            return null;
        }
    }

    private static String decode(String source){
        try {
            return URLDecoder.decode(source,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            return URLDecoder.decode(source);
        }
    }

    private static String removeSemicolonContentInternal(String requestUri) {
        int semicolonIndex = requestUri.indexOf(';');
        while (semicolonIndex != -1) {
            int slashIndex = requestUri.indexOf('/', semicolonIndex);
            String start = requestUri.substring(0, semicolonIndex);
            requestUri = (slashIndex != -1) ? start + requestUri.substring(slashIndex) : start;
            semicolonIndex = requestUri.indexOf(';', semicolonIndex);
        }
        return requestUri;
    }

    private static String getSanitizedPath(final String path) {
        String sanitized = path;
        while (true) {
            int index = sanitized.indexOf("//");
            if (index < 0) {
                break;
            }
            else {
                sanitized = sanitized.substring(0, index) + sanitized.substring(index + 1);
            }
        }
        return sanitized;
    }
}
