package cn.com.duiba.kjy.base.utils;


import cn.com.duiba.kjy.base.api.utils.MD5Util;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;


/**
 * aes 工具类
 * 算法为 AES-128-CBC，数据采用PKCS#5填充
 *
 * @author xuzhigang
 * @date 2022/7/1 5:26 下午
 **/
@Slf4j
public class AesUtil {
    private static String AES_MODE = "AES/CBC/PKCS5Padding";
    private static String CIPHER = "AES";
    private static String CHARSET = "UTF-8";
    private static byte[] IV_BYTES = "efghefghefghefgh".getBytes();

    private static SecretKeySpec generateKey(byte[] password) {
        return new SecretKeySpec(password, CIPHER);
    }

    /**
     * aes加密原内容，加密结果base64
     * @param content 原文
     * @param secret 秘钥
     * @return base64密文
     */
    public static String encryptBase64(String content, String secret) {
        if (content == null || secret == null) {
            return null;
        }
        try {
            SecretKeySpec key = generateKey(secret.getBytes(StandardCharsets.UTF_8));
            byte[] cipherText = encrypt(key, getIvBytes(secret), content.getBytes());
            return Base64.getEncoder().encodeToString(cipherText);
        } catch (Exception e) {
            log.error("encrypt error! content={} secret={}", content, secret, e);
        }
        return null;
    }

    public static byte[] encrypt(SecretKeySpec key, byte[] iv, byte[] message) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(Cipher.ENCRYPT_MODE, key, ivSpec);
        return cipher.doFinal(message);
    }

    /**
     * aes解密base64加密串
     * @param base64Content 原文
     * @param secret 秘钥
     * @return 原文
     */
    public static String decryptBase64(String base64Content, String secret) {
        if (base64Content == null || secret == null) {
            return null;
        }
        try {
            SecretKeySpec key = generateKey(secret.getBytes(StandardCharsets.UTF_8));
            byte[] decodedCipherText = Base64.getDecoder().decode(base64Content);
            byte[] decryptedBytes = decrypt(key, getIvBytes(secret), decodedCipherText);
            return new String(decryptedBytes);
        } catch (Exception e) {
            log.error("decryptBase64 error! base64Content={}, secret={}", base64Content, secret);
        }
        return null;
    }

    private static byte[] decrypt(SecretKeySpec key, byte[] iv, byte[] decodedCipherText) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(Cipher.DECRYPT_MODE, key, ivSpec);
        return cipher.doFinal(decodedCipherText);
    }

    private static byte[] getIvBytes(String secret) {
        String ivString = StringUtils.substring(MD5Util.toMD5String(secret), 0, 16);
        if (ivString == null) {
            return null;
        }
        return ivString.getBytes(StandardCharsets.UTF_8);
    }

    //测试
    public static void main(String[] args) {
        String secret = "1111111111111111";
        String encryptBase64 = AesUtil.encryptBase64("123456", secret);
        System.out.println(encryptBase64);
        System.out.println(AesUtil.decryptBase64(encryptBase64, secret));
    }
}
