package cn.com.duiba.kjy.base.common.bean;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 可注解Controller bean or Controller handler method
 * 同时使用时不会合并两注解，method  优先于 bean
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE,ElementType.METHOD})
public @interface CrossDomain {


    /**
     * The list of allowed origins that be specific origins, e.g.
     * {@code "https://domain1.com"}, or {@code "*"} for all origins.
     * <p>A matched origin is listed in the {@code Access-Control-Allow-Origin}
     * response header of preflight actual CORS requests.
     * <p>By default all origins are allowed.
     * <p><strong>Note:</strong> CORS checks use values from "Forwarded"
     * (<a href="https://tools.ietf.org/html/rfc7239">RFC 7239</a>),
     * "X-Forwarded-Host", "X-Forwarded-Port", and "X-Forwarded-Proto" headers,
     * if present, in order to reflect the client-originated address.
     * Consider using the {@code ForwardedHeaderFilter} in order to choose from a
     * central place whether to extract and use, or to discard such headers.
     * See the Spring Framework reference for more on this filter.
     */
    String[] origins() default {};

    /**
     * The list of request headers that are permitted in actual requests,
     * possibly {@code "*"}  to allow all headers.
     * <p>Allowed headers are listed in the {@code Access-Control-Allow-Headers}
     * response header of preflight requests.
     * <p>A header name is not required to be listed if it is one of:
     * {@code Cache-Control}, {@code Content-Language}, {@code Expires},
     * {@code Last-Modified}, or {@code Pragma} as per the CORS spec.
     * <p>By default all requested headers are allowed.
     */
    String[] allowedHeaders() default {};

    /**
     * The List of response headers that the user-agent will allow the client
     * to access on an actual response, other than "simple" headers, i.e.
     * {@code Cache-Control}, {@code Content-Language}, {@code Content-Type},
     * {@code Expires}, {@code Last-Modified}, or {@code Pragma},
     * <p>Exposed headers are listed in the {@code Access-Control-Expose-Headers}
     * response header of actual CORS requests.
     * <p>By default no headers are listed as exposed.
     */
    String[] exposedHeaders() default {};

    /**
     * Whether the browser should send credentials, such as cookies along with
     * cross domain requests, to the annotated endpoint. The configured value is
     * set on the {@code Access-Control-Allow-Credentials} response header of
     * preflight requests.
     * <p><strong>NOTE:</strong> Be aware that this option establishes a high
     * level of trust with the configured domains and also increases the surface
     * attack of the web application by exposing sensitive user-specific
     * information such as cookies and CSRF tokens.
     * <p>By default this is not set in which case the
     * {@code Access-Control-Allow-Credentials} header is also not set and
     * credentials are therefore not allowed.
     */
    String allowCredentials() default "";

    /**
     * The maximum age (in seconds) of the cache duration for preflight responses.
     * <p>This property controls the value of the {@code Access-Control-Max-Age}
     * response header of preflight requests.
     * <p>Setting this to a reasonable value can reduce the number of preflight
     * request/response interactions required by the browser.
     * A negative value means <em>undefined</em>.
     * <p>By default this is set to {@code 1800} seconds (30 minutes).
     */
    long maxAge() default -1;

}
