package cn.com.duiba.kjy.base.customweb.web.adaptor;

import cn.com.duiba.kjy.base.customweb.exception.ArgResolverException;
import cn.com.duiba.kjy.base.customweb.exception.ResponseStatusException;
import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.StopWatch;

import javax.validation.ConstraintViolationException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/24 11:47 下午
 */
@Slf4j
public class RequestHandlerMappingAdaptor {

    public Object handler(Object handler, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        //option 请求作为C/S验证请求，到这里就差不多了。
        if (Objects.equals(httpRequest.getMethod(), HttpMethod.OPTIONS.name())){
            return null;
        }
        try {
            ControllerMappingHandler handlerMapping = (ControllerMappingHandler)handler;
            final List<ParameterBean> paramList = handlerMapping.getParamList();
            final StopWatch stopWatch = StopWatchUtil.getAndStart();
            final Object[] params = getArgs(httpRequest, paramList,response);
            StopWatchUtil.stop(StopWatchUtil.Key.ARGS,httpRequest,stopWatch);
            if (Objects.equals(handlerMapping.getReturnType(),Void.class)){
                handlerMapping.getHandlerMethod().invoke(handlerMapping.getHandlerObject(),params);
                return null;
            }
            return handlerMapping.getHandlerMethod().invoke(handlerMapping.getHandlerObject(),params);
        }catch (InvocationTargetException e){
            //反射的过程中发生的异常，会包裹一次，这里暴露原始异常
            throw e.getTargetException();
        }catch (IllegalAccessException e){
            // private 等无法访问的方法
            throw new ResponseStatusException(HttpResponseStatus.FORBIDDEN);
        }
    }

    @NotNull
    private Object[] getArgs(KjjHttpRequest httpRequest, List<ParameterBean> paramList, KjjHttpResponse response) throws Throwable {
        if (CollectionUtils.isEmpty(paramList)){
            return new Object[0];
        }
        try {
            List<Object> list = new ArrayList<>();
            for (ParameterBean parameterBean : paramList) {
                Object arg = parameterBean.getArgsResolver().doResolver(parameterBean, httpRequest,response);
                list.add(arg);
            }
            return list.toArray();
        }catch (ConstraintViolationException e){
            throw e;
        }catch (Throwable th){
            throw new ArgResolverException("arguments resolver has error ! uri = "+ httpRequest.uri(),th);
        }
    }

    public void handlerResult(Object result, KjjHttpRequest httpRequest, KjjHttpResponse response, Object handler) throws Throwable {
        if (!httpRequest.isSync() || response.isClosed()){
            //异步请求的支持
            return;
        }
        ControllerMappingHandler handlerMapping = (ControllerMappingHandler)handler;
        final ResponseHandler responseHandler = handlerMapping.getResponseHandler();
        responseHandler.write(result,httpRequest,response);
    }
}
