package cn.com.duiba.kjy.base.customweb.web.codec.jackson;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.math.NumberUtils;

import java.io.IOException;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/28 1:24 下午
 */
@Slf4j
public class JacksonIdSerialization extends JsonSerializer {

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (Objects.isNull(value)){
            return;
        }
        if (value instanceof Long){
            gen.writeString(IdMakeUtil.encodingId((Long)value));
        }else if(value instanceof String && NumberUtils.isCreatable((String)value)){
            gen.writeString(IdMakeUtil.encodingId(Long.valueOf((String)value)));
        }else{
            log.error("can not serializer value = {} when using id make serializer!",value);
            gen.writeString("");
        }
    }
}
