package cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller;

import cn.com.duiba.kjy.base.customweb.autoconfig.MappingCrosDomainConfig;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bean.RequestTypeEnum;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.lang.reflect.Method;
import java.util.List;

/**
 * @author dugq
 * @date 2021/3/23 7:16 下午
 */
@Getter
@AllArgsConstructor
public class ControllerMappingHandler {

    private final Class<?> handlerClass;

    /**
     * spring IOC bean name
     */
    private final String handler;

    private final Method handlerMethod;

    private final List<ParameterBean> paramList;

    /**
     * the type of http request
     */
    private final RequestTypeEnum requestType;

    private final RequestMappingInfo requestMappingInfo;

    /**
     * request handler return obj class type
     */
    private final Class<?> returnType;

    /**
     * the bean of request handler
     */
    private Object handlerObject;

    /**
     * the processor of deal response
     */
    private final ResponseHandler responseHandler;

    private final MappingCrosDomainConfig mappingCrosDomainConfig;

    public void setHandlerObject(Object handlerObject) {
        this.handlerObject = handlerObject;
    }
}
