package cn.com.duiba.kjy.base.customweb.web.processor;

import cn.com.duiba.kjy.base.customweb.web.factory.FilterChainFactory;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import javax.annotation.Resource;

/**
 * @author dugq
 * @date 2021/3/25 1:46 下午
 */
public class FilterBeanPostProcessor implements BeanPostProcessor {
    @Resource
    private FilterChainFactory filterChainFactory;

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof CustomFilter){
            filterChainFactory.addFilter((CustomFilter)bean);
        }
        return bean;
    }
}
