package cn.com.duiba.kjy.base.api.dto.inner;

import cn.com.duiba.kjy.base.api.enums.inner.InnerLocalLogEventTypeEnum;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import java.io.Serializable;
import java.util.Calendar;

/**
 * 内部日志-本地化版本，工具类
 * @author lizhi
 * @date 2022/8/26 2:44 下午
 */
public class InnerLocalLog<V extends Serializable> {

    private static final Logger innerLocalLog = LoggerFactory.getLogger("innerLocalLog");

    private InnerLocalLog() {}

    private final JSONObject fieldJson = new JSONObject();

    private InnerLocalLogEventTypeEnum eventTypeEnum;


    /**
     * 构建内部日志工具类
     * @param eventTypeEnum 事件枚举
     * @return 工具类实例
     */
    public static InnerLocalLog<Serializable> newInstance(@Nonnull InnerLocalLogEventTypeEnum eventTypeEnum) {
        InnerLocalLog<Serializable> util = new InnerLocalLog<>();
        util.eventTypeEnum = eventTypeEnum;
        return util;
    }

    /**
     * 添加json字段
     * @param fieldName 字段名称
     * @param fieldValue 字段值
     * @return 工具类实例
     */
    public InnerLocalLog<V> addField(String fieldName, V fieldValue) {
        this.fieldJson.put(fieldName, fieldValue);
        return this;
    }

    /**
     * 打印内部日志
     */
    public void printLog() {
        this.fieldJson.put("log_id", UUIDUtils.createUUID());
        this.fieldJson.put("log_time", DateFormatUtils.format(Calendar.getInstance(), "yyyy-MM-dd HH:mm:ss"));
        this.fieldJson.put("event_type", eventTypeEnum.getEventType());
        // 表示直播
        this.fieldJson.put("platform_type", 2);
        innerLocalLog.info(this.fieldJson.toJSONString());
    }
}
