package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingRegister;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.entity.ContentType;
import org.springframework.boot.actuate.beans.BeansEndpoint;
import org.springframework.boot.actuate.management.ThreadDumpEndpoint;
import org.springframework.cloud.context.refresh.ContextRefresher;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/28 4:47 下午
 * 这里都是些端点的临时解决方案，因为我们当前并没有端点处理器
 */
@Slf4j
public class ActuateFilter implements CustomFilter {

    private final BeansEndpoint beansEndpoint;
    @Resource
    private ControllerMappingRegister controllerMappingRegister;
    private ThreadDumpEndpoint threadDumpEndpoint;

    @Resource
    private ContextRefresher contextRefresher;

    public ActuateFilter(BeansEndpoint beansEndpoint,ThreadDumpEndpoint threadDumpEndpoint) {
        this.beansEndpoint = beansEndpoint;
        this.threadDumpEndpoint = threadDumpEndpoint;
    }

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        final String path = httpRequest.getUri().getPath();
        if (!path.startsWith("/actuator")){
            customFilterChain.filter(httpRequest, response);
            return;
        }
        switch (path){
            case "/actuator/beans":
                response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                if (Objects.nonNull(beansEndpoint)){
                    response.write(JSON.toJSONString(beansEndpoint.beans()));
                }else{
                    response.write("no auth!");
                }
                response.flushAndClose();
                return;
            case "/actuator/mappings":
                response.write(JSON.toJSONString(controllerMappingRegister.getHandlerList()));
                response.flushAndClose();
                return;
            case "/actuator/threaddump":
                if (Objects.nonNull(threadDumpEndpoint)){
                    response.write(JSON.toJSONString(threadDumpEndpoint.threadDump()));
                    response.flushAndClose();
                    return;
                }
            case "/actuator/evn":
                if (Objects.nonNull(threadDumpEndpoint)){
                    response.write(JSON.toJSONString(threadDumpEndpoint.threadDump()));
                    response.flushAndClose();
                    return;
                }
            case "/actuator/times":
                response.write(JSON.toJSONString(StopWatchUtil.getAndClear()));
                response.flushAndClose();
                return;
            case "/actuator/refresh":
                response.write(JSON.toJSONString(contextRefresher.refresh()));
                response.write("");
                response.flushAndClose();
                return;
            default:customFilterChain.filter(httpRequest, response);
        }
    }

}
