package cn.com.duiba.kjy.base.customweb.web.handler.exception;

import cn.com.duiba.kjy.base.customweb.exception.ExceptionHandlerException;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.web.method.ControllerAdviceBean;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.LinkedList;
import java.util.List;

/**
 * @author dugq
 * @date 2021/3/28 11:34 下午
 */
@Slf4j
public class ExceptionChain extends ApplicationObjectSupport {
    @Resource
    private DefaultExceptionHandler defaultExceptionHandler;

    private final LinkedList<ExceptionHandler> exceptionHandlerList = new LinkedList<>();

    @Resource
    private ObjectMapper objectMapper;

    public ExceptionChain(List<ExceptionHandler> handlerList) {
        this.exceptionHandlerList.addAll(handlerList);
    }

    @PostConstruct
    public void init(){
        final List<ControllerAdviceBean> annotatedBeans = ControllerAdviceBean.findAnnotatedBeans(getApplicationContext());
        this.exceptionHandlerList.addFirst(new ControllerAdviceHandler(annotatedBeans,objectMapper));
        this.exceptionHandlerList.addFirst(new ResponseStatusExceptionHandler());
    }


    public void handlerException(KjjHttpRequest request, KjjHttpResponse response, Throwable e) {
        try {
            for (ExceptionHandler exceptionHandler : exceptionHandlerList) {
                if (exceptionHandler.doHandler(request,response,e)){
                    return;
                }
            }
        }catch (Exception e2){
            defaultExceptionHandler.doHandler(request, response, new ExceptionHandlerException(e,e2));
        }

    }
}
