/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.queue;

import cn.com.duiba.kjy.base.api.queue.AbstractQueueService;
import cn.com.duiba.kjy.base.api.queue.HttpRequestBaseBean;
import cn.com.duiba.kjy.base.api.request.ErrorCodeInterface;
import cn.com.duiba.kjy.base.api.request.Result;
import cn.com.duiba.kjy.base.api.request.ResultBuilders;
import cn.com.duiba.kjy.base.api.response.ResponseUtils;
import cn.com.duiba.kjy.base.exception.errorcode.BaseErrorCode;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpQueueService<T extends HttpRequestBaseBean>
extends AbstractQueueService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpQueueService.class);

    public AbstractHttpQueueService(int capacity, int batchSize, int maxWaitSize, int maxWaitTimeMillis) {
        super(capacity, batchSize, maxWaitSize, maxWaitTimeMillis);
    }

    @Override
    public void addQueue(T t) {
        try {
            super.addQueue(t);
        }
        catch (IllegalStateException e) {
            log.warn("addQueue, queue full or queue not start, class={}, e:", (Object)this.getClass().getName(), (Object)e);
            this.overRequestFail(t, BaseErrorCode.SYSTEM_BUSY);
        }
        catch (Exception e) {
            log.error("addQueue, error, class={}, e:", (Object)this.getClass().getName(), (Object)e);
            this.overRequestFail(t, BaseErrorCode.SYSTEM_BUSY);
        }
    }

    @Override
    protected void batchConsume(List<T> list) {
        this.batchConsumeHttpMsg(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void batchConsumeHttpMsg(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<AsyncContext> contextList = list.stream().map(HttpRequestBaseBean::getContext).collect(Collectors.toList());
        try {
            this.batchConsumeMsg(list);
        }
        catch (Exception e) {
            this.batchOverRequestFail(list, BaseErrorCode.SYSTEM_BUSY);
            log.error("batchConsumeHttpMsg, class={}, e:", (Object)this.getClass().getName(), (Object)e);
        }
        finally {
            contextList.forEach(this::overRequest);
        }
    }

    protected <R> void overRequestSuccess(T httpRequestBaseBean, R resultVo) {
        this.overRequest(httpRequestBaseBean, ResultBuilders.success(resultVo));
    }

    protected void overRequestFail(T httpRequestBaseBean, ErrorCodeInterface errorCode) {
        this.overRequest(httpRequestBaseBean, ResultBuilders.fail(errorCode));
    }

    protected <R> void batchOverRequestSuccess(List<T> subBeanList, R resultVo) {
        this.batchOverRequest(subBeanList, ResultBuilders.success(resultVo));
    }

    protected void batchOverRequestFail(List<T> subBeanList, ErrorCodeInterface errorCode) {
        this.batchOverRequest(subBeanList, ResultBuilders.fail(errorCode));
    }

    private <R> void batchOverRequest(List<T> subBeanList, Result<R> result) {
        if (CollectionUtils.isEmpty(subBeanList)) {
            return;
        }
        subBeanList.forEach(bean -> this.overRequest(bean, result));
    }

    private <R> void overRequest(T bean, Result<R> result) {
        try {
            this.log(bean, result);
            ResponseUtils.out((HttpServletResponse)((HttpRequestBaseBean)bean).getContext().getResponse(), result);
            ((HttpRequestBaseBean)bean).getContext().complete();
        }
        catch (Exception e) {
            log.warn("\u7ed3\u675f\u8bf7\u6c42\u9519\u8bef, class={}", (Object)this.getClass().getName(), (Object)e);
        }
    }

    private <R> void log(T bean, Result<R> result) {
        try {
            HttpServletRequest request = (HttpServletRequest)((HttpRequestBaseBean)bean).getContext().getRequest();
            String uri = request.getRequestURI();
            JSONObject jsonObject = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)uri)) {
                jsonObject.put("url_path", (Object)StringUtils.replace((String)uri, (String)"//", (String)"/"));
            }
            if (result != null) {
                jsonObject.put("resp_body", (Object)this.getResponseBody(result));
            }
            jsonObject.put("live_user_id", (Object)((HttpRequestBaseBean)bean).getLiveUserId());
            log.info("accessLog:{}", (Object)jsonObject.toJSONString());
        }
        catch (Exception e) {
            log.error("log, ", (Throwable)e);
        }
    }

    private <R> String getResponseBody(Result<R> result) {
        String code = result.getCode();
        if (!Objects.equals("000000", code)) {
            return code;
        }
        R data = result.getData();
        return String.valueOf(data);
    }

    protected void overRequest(AsyncContext context) {
        ServletResponse response;
        if (context == null) {
            return;
        }
        try {
            response = context.getResponse();
            if (response == null || response.isCommitted()) {
                return;
            }
        }
        catch (IllegalStateException e) {
            return;
        }
        catch (Exception e) {
            log.warn("overRequest, get response fail, e:", (Throwable)e);
            return;
        }
        try {
            log.error("overRequest, not close, class={}", (Object)this.getClass().getName());
            ResponseUtils.out((HttpServletResponse)response, ResultBuilders.fail(BaseErrorCode.SYSTEM_ERROR));
            context.complete();
        }
        catch (Exception e) {
            log.warn("overRequest, error, class={}", (Object)this.getClass().getName(), (Object)e);
        }
    }
}

