/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import org.apache.commons.lang3.StringUtils;

public class DefaultNicknameUtils {
    private static final String DEFAULT_PREFIX = "\u7528\u6237";
    private static final int ID_LENGTH = 12;
    private static final String REPLACE_NUM = "0";

    private DefaultNicknameUtils() {
    }

    public static String getDefaultName(Long userId) {
        if (NumberUtil.isNullOrLteZero(userId)) {
            return DEFAULT_PREFIX;
        }
        String encodingId = IdMakeUtil.encodingId(userId);
        return DEFAULT_PREFIX + DefaultNicknameUtils.getNameId(encodingId);
    }

    private static String getNameId(String encodingId) {
        if (StringUtils.isBlank((CharSequence)encodingId)) {
            return "";
        }
        if (encodingId.length() > 12) {
            return encodingId.substring(encodingId.length() - 12);
        }
        if (encodingId.length() == 12) {
            return encodingId;
        }
        int replaceLength = 12 - encodingId.length();
        return DefaultNicknameUtils.getZero(replaceLength) + encodingId;
    }

    private static String getZero(int num) {
        if (num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append(REPLACE_NUM);
        }
        return sb.toString();
    }
}

