/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.kjy.base.api.enums.oa.OaLoginTypeEnum;
import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import cn.com.duiba.kjy.base.api.utils.UrlUtils;
import org.apache.commons.lang3.StringUtils;

public class WechatOaLoginUtil {
    private static final String LOGIN_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect";
    private static final String LIVE_H5_CALLBACK_URI = "/auth/live/h5/callback";

    private WechatOaLoginUtil() {
    }

    public static String getLiveH5LoginUrl(String server, String appId, String from, OaLoginTypeEnum loginTypeEnum, Long liveId) {
        String encodeFrom = UrlUtils.encoder(from);
        String url = server + LIVE_H5_CALLBACK_URI;
        String redirectUri = UrlUtils.appendQueryParam(url, "from=" + encodeFrom, "type=" + loginTypeEnum.getType(), "appId=" + appId);
        if (NumberUtil.isNotNullOrLteZero(liveId)) {
            redirectUri = UrlUtils.appendQueryParam(redirectUri, "liveId=" + IdMakeUtil.encodingId(liveId));
        }
        return WechatOaLoginUtil.getLoginUrl(appId, redirectUri, loginTypeEnum, null);
    }

    private static String getLoginUrl(String appId, String redirectUri, OaLoginTypeEnum loginTypeEnum, String state) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, redirectUri}) || loginTypeEnum == null) {
            return null;
        }
        if (state == null) {
            state = "";
        }
        return String.format(LOGIN_URL, appId, UrlUtils.encoder(redirectUri), loginTypeEnum.getScope(), state);
    }
}

