/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.codec.jackson;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonIdSerialization
extends JsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(JacksonIdSerialization.class);

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (Objects.isNull(value)) {
            return;
        }
        if (value instanceof Long) {
            gen.writeString(IdMakeUtil.encodingId((Long)value));
        } else if (value instanceof String && NumberUtils.isCreatable((String)((String)value))) {
            gen.writeString(IdMakeUtil.encodingId(Long.valueOf((String)value)));
        } else {
            log.error("can not serializer value = {} when using id make serializer!", value);
            gen.writeString("");
        }
    }
}

