/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller;

import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappingsRegister;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.RequestMappingInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.support.ApplicationObjectSupport;

public class ControllerMappingRegister
extends ApplicationObjectSupport
implements RequestMappingsRegister {
    @Resource
    private RequestHandlerMappingAdaptor requestHandlerMappingAdaptor;
    private final Map<RequestMappingInfo, ControllerMappingHandler> HANDLER_MAPPING_BEAN_MAP = new HashMap<RequestMappingInfo, ControllerMappingHandler>();
    private final Map<String, RequestMappingInfo> cache = new HashMap<String, RequestMappingInfo>();

    public void registerHandler(ControllerMappingHandler controllerMappingHandler) {
        if (Objects.isNull(controllerMappingHandler)) {
            return;
        }
        this.HANDLER_MAPPING_BEAN_MAP.put(controllerMappingHandler.getRequestMappingInfo(), controllerMappingHandler);
    }

    @Override
    public Object getHandler(KjjHttpRequest fullHttpRequest) {
        String path = fullHttpRequest.getUri().getPath();
        RequestMappingInfo requestMappingInfo = this.cache.get(path);
        if (Objects.isNull(requestMappingInfo)) {
            RequestMappingInfo reqMapping = this.getReqMapping(fullHttpRequest);
            if (Objects.nonNull(reqMapping)) {
                this.cache.put(path, reqMapping);
                return this.resolverHandler(reqMapping);
            }
        } else {
            boolean matchingCondition = requestMappingInfo.getMatchingCondition(fullHttpRequest);
            if (matchingCondition) {
                return this.resolverHandler(requestMappingInfo);
            }
            RequestMappingInfo reqMapping = this.getReqMapping(fullHttpRequest);
            if (Objects.nonNull(reqMapping)) {
                this.cache.put(path, reqMapping);
                return this.resolverHandler(reqMapping);
            }
        }
        return null;
    }

    private Object resolverHandler(RequestMappingInfo reqMapping) {
        ControllerMappingHandler controllerMappingHandler = this.HANDLER_MAPPING_BEAN_MAP.get(reqMapping);
        if (Objects.nonNull(controllerMappingHandler) && Objects.isNull(controllerMappingHandler.getHandlerObject())) {
            try {
                Object handlerBean = this.obtainApplicationContext().getBean(controllerMappingHandler.getHandler());
                controllerMappingHandler.setHandlerObject(handlerBean);
            }
            catch (Exception e) {
                return null;
            }
        }
        return controllerMappingHandler;
    }

    private RequestMappingInfo getReqMapping(KjjHttpRequest fullHttpRequest) {
        for (RequestMappingInfo requestMappingInfo : this.HANDLER_MAPPING_BEAN_MAP.keySet()) {
            boolean matchingCondition = requestMappingInfo.getMatchingCondition(fullHttpRequest);
            if (!matchingCondition) continue;
            return requestMappingInfo;
        }
        return null;
    }

    @Override
    public RequestHandlerMappingAdaptor getAdaptor() {
        return this.requestHandlerMappingAdaptor;
    }

    public Collection<ControllerMappingHandler> getHandlerList() {
        return this.HANDLER_MAPPING_BEAN_MAP.values();
    }
}

