/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseListUtils {
    private static final Logger log = LoggerFactory.getLogger(BaseListUtils.class);

    public static <T, K, V> Map<K, V> assembleDoubleList2Map(List<K> keys, List<T> values, BiFunction<K, T, V> valueHandle) {
        return BaseListUtils.assembleDoubleList2Map(new HashMap(), keys, values, Function.identity(), valueHandle);
    }

    public static <K, V> Map<K, V> assembleDoubleList2Map(List<K> keys, List<V> values) {
        return BaseListUtils.assembleDoubleList2Map(new HashMap(), keys, values, Function.identity(), (k, v) -> v);
    }

    public static <T, P, K, V> Map<K, V> assembleDoubleList2Map(Map<K, V> map, List<P> keys, List<T> values, Function<P, K> keyHandle, BiFunction<K, T, V> valueHandle) {
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(values) || keys.size() != values.size()) {
            log.error("the list size of keys and values is  unequals!");
            return null;
        }
        for (int i = 0; i < keys.size(); ++i) {
            K key = keyHandle.apply(keys.get(i));
            V value = valueHandle.apply(key, values.get(i));
            map.put(key, value);
        }
        return map;
    }
}

