/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.utils;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuibaCmsUtil {
    private static final Logger log = LoggerFactory.getLogger(DuibaCmsUtil.class);
    private static final int UID_MIN_LENGTH = 22;
    private static final int DIGIT_LENGTH = 2;
    private static final String PRE_WORD = "KL";

    private DuibaCmsUtil() {
    }

    public static String convert2Uid(Long companyId, Long liveUserId) {
        if (NumberUtil.isNullOrLteZero(companyId) || NumberUtil.isNullOrLteZero(liveUserId)) {
            return "";
        }
        String evn = DuibaCmsUtil.getEvn();
        String encodeCompanyIdStr = DuibaCmsUtil.getEncodeIdStr(String.valueOf(companyId));
        String encodeLiveUserIdStr = DuibaCmsUtil.getEncodeIdStr(String.valueOf(liveUserId));
        if (DuibaCmsUtil.getIdLengthDigit(encodeCompanyIdStr) > 2 || DuibaCmsUtil.getIdLengthDigit(encodeLiveUserIdStr) > 2) {
            return "";
        }
        String digitMark = DuibaCmsUtil.getDigitMark(encodeCompanyIdStr) + DuibaCmsUtil.getDigitMark(encodeLiveUserIdStr);
        String encodeIdStr = encodeCompanyIdStr + encodeLiveUserIdStr;
        int sureLength = PRE_WORD.length() + evn.length() + 1 + digitMark.length() + encodeIdStr.length();
        String replaceStr = DuibaCmsUtil.getReplaceStr(encodeIdStr, 22 - sureLength);
        return PRE_WORD + evn + "1" + digitMark + replaceStr + encodeIdStr;
    }

    public static Pair<Long, Long> parseFromUid(String uid) {
        if (StringUtils.isBlank((CharSequence)uid)) {
            return Pair.of(null, null);
        }
        String pre = PRE_WORD + DuibaCmsUtil.getEvn();
        if (!uid.startsWith(pre)) {
            return Pair.of(null, null);
        }
        int digitStartIndex = pre.length() + 1;
        int companyIdLength = DuibaCmsUtil.parseIdLength(uid, digitStartIndex);
        int liveUserIdLength = DuibaCmsUtil.parseIdLength(uid, digitStartIndex + 2);
        Long companyId = DuibaCmsUtil.decodeId(uid, uid.length() - liveUserIdLength - companyIdLength, uid.length() - liveUserIdLength);
        Long liveUserId = DuibaCmsUtil.decodeId(uid, uid.length() - liveUserIdLength, uid.length());
        return Pair.of((Object)companyId, (Object)liveUserId);
    }

    private static Long decodeId(String uid, int startIndex, int endIndex) {
        String encodeIdStr = uid.substring(startIndex, endIndex);
        String decodeIdStr = DuibaCmsUtil.getDecodeIdStr(encodeIdStr);
        try {
            return Long.parseLong(decodeIdStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int parseIdLength(String uid, int startIndex) {
        String idDigit = uid.substring(startIndex, startIndex + 2);
        return Integer.parseInt(idDigit);
    }

    private static String getEvn() {
        if (SpringEnvironmentUtils.isProdEnv() || SpringEnvironmentUtils.isPreEnv()) {
            return "P";
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return "T";
        }
        return "D";
    }

    private static String getDigitMark(String encodeIdStr) {
        int length = encodeIdStr.length();
        int digit = DuibaCmsUtil.getLengthDigit(length);
        int zeroNum = 2 - digit;
        return DuibaCmsUtil.getZero(zeroNum) + length;
    }

    private static int getIdLengthDigit(String encodeIdStr) {
        int length = encodeIdStr.length();
        return DuibaCmsUtil.getLengthDigit(length);
    }

    private static int getLengthDigit(int length) {
        String lengthStr = String.valueOf(length);
        return lengthStr.length();
    }

    private static String getEncodeIdStr(String idStr) {
        char[] chars = idStr.toCharArray();
        DuibaCmsUtil.convert(chars);
        DuibaCmsUtil.exchange(chars);
        return new String(chars);
    }

    private static String getDecodeIdStr(String encodeIdStr) {
        if (encodeIdStr == null || encodeIdStr.trim().length() == 0) {
            return encodeIdStr;
        }
        char[] chars = encodeIdStr.toCharArray();
        DuibaCmsUtil.decodeExchange(chars);
        DuibaCmsUtil.decodeConvert(chars);
        return new String(chars);
    }

    private static void decodeExchange(char[] chars) {
        DuibaCmsUtil.exchange(chars);
    }

    private static void exchange(char[] chars) {
        for (int i = 0; i < chars.length / 2; ++i) {
            int index = i * 2;
            char temp = chars[index];
            chars[index] = chars[index + 1];
            chars[index + 1] = temp;
        }
    }

    private static void decodeConvert(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i]));
            num = num >= 7 ? (num -= 7) : (num += 3);
            chars[i] = (char)(num + 48);
        }
    }

    private static void convert(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i]));
            num = (num + 7) % 10;
            chars[i] = (char)(num + 48);
        }
    }

    private static String getReplaceStr(String encodeIdStr, int replaceLength) {
        if (replaceLength <= 0) {
            return "";
        }
        int num = replaceLength - encodeIdStr.length();
        String replaceStr = num < 0 ? encodeIdStr.substring(0, replaceLength) : (num == 0 ? encodeIdStr : DuibaCmsUtil.getZero(num / 2) + encodeIdStr + DuibaCmsUtil.getZero(num - num / 2));
        return DuibaCmsUtil.replace(replaceStr);
    }

    private static String replace(String replaceStr) {
        char[] chars = replaceStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i])) + i + 1;
            int pow = num * num;
            int yu = (num + i) % 10;
            if (yu == 0) {
                yu = 10;
            }
            int result = pow % yu;
            chars[i] = (char)(result + 48);
        }
        return new String(chars);
    }

    private static String getZero(int num) {
        if (num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }
}

