package cn.com.duiba.kjy.base.api.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * 默认昵称工具类
 * @author lizhi
 * @date 2023/1/10 1:40 下午
 */
public class DefaultNicknameUtils {

    private DefaultNicknameUtils() {}

    /**
     * 默认用户昵称前缀
     */
    private static final String DEFAULT_PREFIX = "用户";

    /**
     * 默认用户昵称ID长度
     */
    private static final int ID_LENGTH = 12;

    /**
     * 默认用户昵称ID长度不足时，补的字符串
     */
    private static final String REPLACE_NUM = "0";

    /**
     * 根据用户ID，生成默认昵称
     * @param userId 用户ID
     * @return 默认昵称
     */
    public static String getDefaultName(Long userId) {
        if (NumberUtil.isNullOrLteZero(userId)) {
            return DEFAULT_PREFIX;
        }
        String encodingId = IdMakeUtil.encodingId(userId);
        return DEFAULT_PREFIX + getNameId(encodingId);
    }

    private static String getNameId(String encodingId) {
        if (StringUtils.isBlank(encodingId)) {
            return "";
        }
        if (encodingId.length() > ID_LENGTH) {
            // 大于指定长度，直接截取后XX位
            return encodingId.substring(encodingId.length() - ID_LENGTH);
        }
        if (encodingId.length() == ID_LENGTH) {
            // 长度相等，直接返回
            return encodingId;
        }
        // 小于指定长度，补0
        int replaceLength = ID_LENGTH - encodingId.length();
        return getZero(replaceLength) + encodingId;
    }

    /**
     * 获取0
     * @param num 需要的0的个数
     * @return 0字符串
     */
    private static String getZero(int num) {
        if (num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; i++) {
            sb.append(REPLACE_NUM);
        }
        return sb.toString();
    }
}
