package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import lombok.extern.slf4j.Slf4j;

/**
 * @author dugq
 * @date 2021/5/28 10:51 上午
 */
@Slf4j
public class ListenerFilter implements CustomFilter {

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        final long start = System.currentTimeMillis();
        try {
            customFilterChain.filter(httpRequest, response);
        } finally {
            try {
                final long end = System.currentTimeMillis();
                long during = end - start;
                if (during > 200) {
                    log.warn("url ={} cost time = {} ms.", httpRequest.getRequestURI(), during);
                } else if (during > 20) {
                    log.info("url ={} cost time = {} ms.", httpRequest.getRequestURI(), during);
                }
            } catch (Exception e1) {
                log.info("listener has ex ", e1);
            }
        }

    }

}
