package cn.com.duiba.kjy.base.reactive.util;

import com.alibaba.fastjson.JSONObject;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/16 3:19 下午
 */
public class ReactResponseUtils {

    public static  <T extends Serializable> Mono<Void> writeMessage(ServerWebExchange serverWebExchange, T message){
        if (Objects.isNull(message)){
            return Mono.empty();
        }
        final ServerHttpResponse response = serverWebExchange.getResponse();
        if (message instanceof String){
            return writeMsg((String) message, response);
        }
        return writeMsg(JSONObject.toJSONString(message), response);
    }

    public static <T extends Serializable> Mono<Void> writeMsg(String message, ServerHttpResponse response) {
        final DataBuffer wrap = response.bufferFactory().wrap(message.getBytes());
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        return response.writeWith(Mono.just(wrap));
    }

}
