package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAgentDto;
import cn.com.duiba.kjy.livecenter.api.param.liveagent.LiveAgentPageQueryParam;

import java.util.List;

/**
 * 直播代理人rpc服务类
 * @author 吴文哲
 * @date 2020-03-30 21:00
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentService {


    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播公司团队
     */
    LiveAgentDto findById(Long id);

    /**
     * 根据主键id查找列表
     * @param ids
     * @return
     */
    List<LiveAgentDto> findByIds(List<Long> ids);

    /**
     * 根据团队id 统计
     * @param teamId
     * @return
     */
    Integer countByTeamId(Long teamId);

    /**
     * 将代理人从团队中移除
     * @return
     */
    Integer removeAgentFromTeam(Long agentId,Long teamId);

    /**
     * 根据团队id 查找直播代理人列表
     * @param teamId
     * @return
     */
    List<LiveAgentDto> findByTeamId(Long teamId);

    /**
     * 从缓存中获取代理人的公司id
     * @param agentId
     * @return
     */
    Long getCompanyIdByAgentIdFromCache(Long agentId);

    /**
     * 根据直播用户id 查找代理人信息
     * @param liveUserId
     * @return
     */
    LiveAgentDto findByLiveUserId(Long liveUserId);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<LiveAgentDto> findListByCondition(LiveAgentPageQueryParam param);

    /**
     * 判断是否是当前公司代理人
     * @param liveUserId
     * @param companyId
     * @return true是 false否
     */
    boolean isCurrentCompanyAgent(long liveUserId, long companyId);

}
