package cn.com.duiba.kjy.livecenter.api.remoteservice.aliyun;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.aliyunlive.TranscribeRecordDto;
import cn.com.duiba.kjy.livecenter.api.param.aliyunlive.TranscribeAddParam;

import java.util.List;

/**
 * Created by dugq on 2020-04-10.
 */
@AdvancedFeignClient
public interface RemoteAliyunTranscribeService {
    /**
     * 查询直播流下的所有视频
     * @param streamId
     * @return
     */
    List<TranscribeRecordDto> selectList(Long streamId);

    /**
     * 查询直播流下的所有视频的数量
     * @param streamId
     * @return
     */
    Integer selectCount(Long streamId);

    /**
     * 新增直播流
     * @param param
     * @return
     */
    int insert(TranscribeAddParam param);
}
