package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyTeamDto;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveCompanyTeamSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.user.LiveUserSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 直播公司团队服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveTeamService {

    /**
     * 根据条件查询列表
     * @param searchParam
     * @return
     */
    List<LiveCompanyTeamDto> findByCondition(LiveCompanyTeamSearchParam searchParam);

    /**
     * 根据条件统计
     * @param searchParam
     * @return
     */
    Integer countByCondition(LiveCompanyTeamSearchParam searchParam);

    /**
     * 根据公司id 统计当前公司下的成员总数
     * @param companyId
     * @return
     */
    Integer getAgentCountByCompanyId(Long companyId);

    /**
     * 统计公司下团队id  对应团队成员数量
     * @param teamIds
     * @return
     */
    Map<Long,Integer> getTeamId2AgentNumMap(List<Long> teamIds);

    /**
     * 保存更新直播公司团队
     * @param dto 直播公司团队
     * @return 主键，为0，说明新增失败
     */
    Long saveAndUpdate(LiveCompanyTeamDto dto);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播公司团队
     */
    LiveCompanyTeamDto findById(Long id);

    /**
     * 根据id批量查询
     * @param ids 主键id列表
     * @return 直播公司团队
     */
    List<LiveCompanyTeamDto> findByIds(List<Long> ids);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Integer deleteById(Long id);
    
}
