package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueRewardDto;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveUserRewardCountDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueRewardPageParam;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueRewardSearchParam;

import java.util.List;

/**
 * 直播线索-奖励领取记录remote
 * @author zhanghuifeng
 * date 2020/4/3-9:17 下午
 */
@AdvancedFeignClient
public interface RemoteLiveClueRewardService {

    /**
     * 新增
     * @param dto 直播线索-奖励领取记录
     * @return 执行结果
     */
    Boolean add(LiveClueRewardDto dto);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveClueRewardSearchParam param);

    /**
     * 分页查询
     * @param pageParam
     * @return
     */
    Page<LiveClueRewardDto> page(LiveClueRewardPageParam pageParam);

    /**
     * 根据直播间ID、用户ID、权益ID集合查询每个权益领取数量
     * @param liveId
     * @param liveVisitorId
     * @param rewardIds
     * @return
     */
    List<LiveUserRewardCountDto> findCountByLiveAndUserAndRewardIds(Long liveId, Long liveVisitorId, List<Long> rewardIds,
                                                                    List<Integer> rewardTypes);

}
