package cn.com.duiba.kjy.livecenter.api.enums.live;

import cn.com.duiba.kjy.livecenter.api.util.NumberUtil;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 直播互动类型枚举
 * @author 吴文哲
 * @date 2020-04-02 15:07
 **/
public enum LiveInteractTypeEnum {

    MATERIAL(1,"图文资料"),
    QUESTION(2,"问题"),
    SUBSCRIBE(3,"关注直播间"),
    ACCUMULATE_READ(4,"累计观看"),
    FRIEND_INVITE(5,"邀请好友"),
    FREE_GET(6,"免费领"),
    GRAB_WELFARE(7,"抢权益"),
    CHOICE(8,"测一测"),
    LINK_RESOURCE(9,"链接资料"),
    OA_RESOURCE(10,"公众号资料"),
            ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LiveInteractTypeEnum(Integer type ,String desc){
        this.type  = type;
        this.desc  = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static List<Integer> welfareTypes = Lists.newArrayList();

    static {
        welfareTypes.addAll(Lists.newArrayList(MATERIAL.getType(),SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(),FREE_GET.getType()));
    }

    public static boolean isWelfare(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return welfareTypes.contains(type);
    }

    public static List<Integer> resourceTypes = Lists.newArrayList();

    static {
        resourceTypes.addAll(Lists.newArrayList(MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType()));
    }

    public static boolean isResource(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return resourceTypes.contains(type);
    }

    // 权益库类型
    public static List<Integer> welfareTableTypes = Lists.newArrayList();

    static {
        welfareTableTypes.addAll(Lists.newArrayList(SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(),FREE_GET.getType(),GRAB_WELFARE.getType()));
    }

    public static boolean isWelfareTable(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return welfareTableTypes.contains(type);
    }

    public static void main(String[] args) {
        System.out.println(isWelfare(2));
    }
}
