package cn.com.duiba.kjy.livecenter.api.enums.live;

/**
 * @author zhanghuifeng
 * date 2020/4/5-3:52 下午
 */
public enum UserAppointmentBizTypeEnum {
    LIVE(1, "直播间ID"),
    LIVE_INTERACT_CONF(2, "直播间奖励配置ID")
    ;

    private Integer code;

    private String desc;

    UserAppointmentBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static UserAppointmentBizTypeEnum getByCode(Integer code) {
        for (UserAppointmentBizTypeEnum enumVal : UserAppointmentBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
