/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotteryCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(LotteryCodeUtil.class);
    private static final int ENCODE_NUMBER_AS_10_STRING_KEY = 0x2AAA555;
    private static final int ENCODE_NUMBER_AS_10_STRING_MAX = 0x3FFFFFF;

    private LotteryCodeUtil() {
    }

    public static String encodeNumberAs10String(long value) {
        if (value > 0x3FFFFFFL) {
            value = value & 2L ^ 0x1AL;
        }
        String val = StringUtils.leftPad((String)String.valueOf(value ^= 0x2AAA555L), (int)8, (String)"0");
        return "N" + val.substring(0, 4) + "K" + val.substring(4);
    }

    public static Long decode10StringAsNumber(String value) {
        if (StringUtils.isBlank((CharSequence)value) || value.length() != 10) {
            return null;
        }
        value = value.substring(1, 5) + value.substring(6);
        try {
            Long number = Long.valueOf(value);
            return number ^ 0x2AAA555L;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        Long aLong = LotteryCodeUtil.decode10StringAsNumber("N4465K9557");
        System.out.println(aLong);
        String encode = LotteryCodeUtil.encodeNumberAs10String(19975803L);
        log.info(encode);
        LotteryCodeUtil.test1();
        log.info(Integer.valueOf("10101010101010010101010101", 2) + "");
        log.info(Integer.valueOf("11111111111111111111111111", 2) + "");
        long pow = (long)Math.pow(2.0, 26.0);
        log.info(pow + "");
        int length = String.valueOf(pow).length();
        log.info(length + "");
        for (int i = 0; i < 1000; ++i) {
            log.info(i + "=" + LotteryCodeUtil.encodeNumberAs10String(i));
        }
    }

    private static void test1() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000000; ++i) {
            String encode = LotteryCodeUtil.encodeNumberAs10String(i);
            Long number = LotteryCodeUtil.decode10StringAsNumber(encode);
            if ((long)i == number || (long)(i & 2 ^ 0x1A) == number) continue;
            log.info(i + "");
        }
        long end = System.currentTimeMillis();
        log.info(end - start + "");
    }
}

