package cn.com.duiba.kjy.livecenter.api.remoteservice.black;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.black.LiveBlackListDto;

import java.util.List;

/**
 * 直播黑名单
 * @author lizhi
 * @date 2020/7/30 10:07 AM
 */
@AdvancedFeignClient
public interface RemoteLiveBlackListService {

    /**
     * 查询在黑名单里的用户
     * @param liveUserIds 需要校验的直播用户ID集合
     * @return 在黑名单里的用户ID集合
     */
    List<Long> findByLiveUserIds(List<Long> liveUserIds);

    /**
     * 批量新增
     * @param list 直播黑名单
     * @return 执行结果
     */
    int batchInsert(List<LiveBlackListDto> list);

    /**
     * 批量物理删除
     * @param liveUserIds 直播用户ID集合
     * @return 执行结果
     */
    int batchDelete(List<Long> liveUserIds);
}
