package cn.com.duiba.kjy.livecenter.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 直播间谁看过我 用户线索vo
 * @author 吴文哲
 * @date 2020-04-08 21:02
 **/
@Data
public class OuterLiveUserClueDto implements Serializable {
    private static final long serialVersionUID = -8653752239644113824L;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 访客-直播系统用户id
     */
    private Long liveUserId;

    /**
     * 小程序授权拿到的手机号
     */
    private String authPhone;

    /**
     * 观看时长(秒)
     */
    private Integer duration;

    /**
     * 是否关注直播间 0:未关注 1:关注
     */
    private Integer subscribe;

    /**
     * 评论条数
     */
    private Integer speakNum;

    /**
     * 用户提问列表
     */
    private List<OutLiveUserQuestionDto> questions;

    /**
     * 用户领取资料列表
     */
    private List<OutLiveUserResourceDto> resources;

    /**
     * 用户领取权益列表
     */
    private List<OutLiveUserWelfareDto> welfares;

    /**
     * 用户回答的选择题
     */
    private List<OuterLiveUserChoiceQuestionDto> choiceQuestions;

    /**
     * 用户提交的报告
     */
    private List<OutLiveUserSubmitDetailDto> registrations;

    /**
     * 线索等级
     */
    private Integer clueLevel;
}
