package cn.com.duiba.kjy.livecenter.api.remoteservice.live.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.push.LivePushDto;

/**
 * 直播推送
 * @author lizhi
 * @date 2020/7/23 11:14 AM
 */
@AdvancedFeignClient
public interface RemoteLivePushService {

    /**
     * 如果不存在，则新增（live_id + push_type 维度）
     * @param dto 推送配置
     * @return 是否成功
     */
    boolean saveIfAbsent(LivePushDto dto);

    /**
     * 根据liveId和推送类型查询推送配置
     *
     * @param liveId liveId
     * @param pushType 推送类型
     * @return 推送配置
     */
    LivePushDto selectByLiveIdAndType(Long liveId, Integer pushType);
}
