package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.user.BizUserIdDto;
import cn.com.duiba.kjy.livecenter.api.dto.user.LiveUserDto;
import cn.com.duiba.kjy.livecenter.api.dto.user.LiveUserNickNameAvatarDto;
import cn.com.duiba.kjy.livecenter.api.dto.user.UserInfo4LoginApiDto;
import cn.com.duiba.kjy.livecenter.api.param.user.LiveUserEsSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.user.LiveUserSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.user.SyncUserApiParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

/**
 * 直播用户服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveUserService {

    /**
     * 列表查询
     * @param queryParam 查询参数
     * @return 直播用户集合
     */
    List<LiveUserDto> findList(LiveUserSearchParam queryParam);

    /**
     * 保存更新直播用户
     * @param dto 直播用户
     * @return 主键，为0，说明新增失败
     */
    Long saveAndUpdate(LiveUserDto dto);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播用户
     */
    LiveUserDto findById(Long id);

    /**
     * 根据第三方用户ID和类型查询用户ID
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @return 主键id
     */
    Long findIdByBizUserIdAndType(String bizUserId, Integer bizType);

    /**
     * 查询授权电话
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @return 授权电话
     */
    String findAuthPhoneByBizUserIdAndType(String bizUserId, Integer bizType);

    /**
     * 批量查询直播系统用户ID
     * @param bizUserIdList 业务方用户ID集合
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @return 业务方ID和直播用户ID
     */
    List<BizUserIdDto> findIdsByBizUserIdsAndType(List<String> bizUserIdList, Integer bizType);

    /**
     * 批量查询授权手机号
     * @param ids 主键ID集合
     * @return key：主键，value：授权手机号
     */
    Map<Long, String> findAuthPhoneByIds(List<Long> ids);


    /**
     * 根据id查询
     * @param ids 主键id列表
     * @return 直播用户
     */
    List<LiveUserDto> findByIds(List<Long> ids);

    /**
     * 批量查询昵称和头像
     * @param ids 主键集合
     * @return 昵称头像集合
     */
    List<LiveUserNickNameAvatarDto> findNicknameAvatarByIds(List<Long> ids);

    /**
     * 更新授权手机号
     * @param id 主键
     * @param authPhone 授权手机号
     * @param authPhoneCountryCode 授权手机号的区号
     * @return 执行结果
     */
    int updateAuthPhone(Long id, String authPhone, String authPhoneCountryCode);

    /**
     * 更新授权手机号
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @param authPhone 授权手机号
     * @param authPhoneCountryCode 授权手机号的区号
     * @return 执行结果
     */
    int updateAuthPhoneByBiz(String bizUserId, Integer bizType, String authPhone, String authPhoneCountryCode);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Long deleteById(Long id);


    /**
     * 根据用户id 获取公司id
     * @param liveUserId
     * @return
     */
    Long findAdminCompanyIdByUserId(Long liveUserId);

    /**
     * 根据授权手机号查询
     * @param authPhone 授权手机号
     * @return 用户信息
     */
    List<LiveUserDto> findByAuthPhone(String authPhone);


    /**
     * 同步第三方用户信息，并返回直播系统用户信息
     * @param param 第三方用户信息
     * @return 本系统用户信息
     */
    UserInfo4LoginApiDto getAndSyncUserV2(SyncUserApiParam param);

    /**
     * 根据三方业务id 业务类型获取 直播系统用户id
     * @param bizUserId 三方业务用户id
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @return  加密的客集集直播系统用户id
     */
    String getLiveUserIdByBizUserIdAndType(String bizUserId,Integer bizType);


    /**
     * 根据访客用户id  获取客集集系统的邀请人业务id
     * @param visitorLiveUserId  客集集访客在直播系统的liveUserId
     * @param liveId 直播系统的id
     * @return 客集集代理邀请人 在直播系统的tb_live_user.bizUserId(即客集集系统的 tb_users.id)
     */
    String  findInvitorUserId4Kjj(Long visitorLiveUserId,Long liveId);


    /**
     * 批量同步用户
     * @param params
     * @return
     */
    List<UserInfo4LoginApiDto> batchGetAndSyncUserV2(List<SyncUserApiParam> params);

    /**
     * 根据昵称搜索用户信息
     *
     * @param nickname 昵称
     * @return 用户信息集合
     */
    List<LiveUserNickNameAvatarDto> searchByNickname(String nickname);

    /**
     * 从es中查询 直播用户信息
     * @param searchParam 查询条件
     * @return key:总数 val:列表
     */
    Pair<Long,List<LiveUserNickNameAvatarDto>> findByConditionFromEs(LiveUserEsSearchParam searchParam);
}
