package cn.com.duiba.kjy.livecenter.api.enums.importtask;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 导入任务类型枚举
 *
 * @author xuzhigang
 * @date 2020/10/21 1:59 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveImportTaskTypeEnum {
    UPLOAD_ACTIVATE_AGENT(1, "上传架构名单"),

    DELETE_ACTIVATE_AGENT(2, "删除架构名单"),

    BATCH_DELETE_PERMISSION(3, "业务员列表-批量删除权限"),

    BATCH_CHANGE_TEAM(4, "业务员列表-批量切换团队"),

    BATCH_UPDATE_AGENT(5, "业务员列表-批量更新信息"),
    ;

    /**
     * 导入任务类型
     */
    private Integer taskType;

    /**
     * 描述
     */
    private String desc;

    private static Map<Integer, LiveImportTaskTypeEnum> map = new HashMap<>();

    static {
        Arrays.stream(values()).forEach(type -> {
            map.put(type.getTaskType(), type);
        });
    }

    /**
     * 根据type获取枚举
     */
    public static LiveImportTaskTypeEnum getEnumByType(Integer type) {
        return map.get(type);
    }
}
