package cn.com.duiba.kjy.livecenter.api.param.guide;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 引导视频-用户观看记录
 * @author kjj mybatis generator 
 * @date 2020-11-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class GuideVideoVisitorStatsSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16055835362947832L;

    /**
     * 直播用户id
     */
    private Long liveVisitorId;

    /**
     * 视频类型：1-基础教程，2-高级教程
     * @see cn.com.duiba.kjy.livecenter.api.enums.guide.GuideVideoTypeEnum
     */
    private Integer videoType;

    /**
     * 引导视频id, tb_guide_video.id
     */
    private Long videoId;

    /**
     * 观看状态，1-未观看，2-观看中，3-已看完
     * @see cn.com.duiba.kjy.livecenter.api.enums.guide.GuideWatchStatusEnum
     */
    private Integer watchStatus;

    /**
     * 引导视频id集合
     */
    private List<Long> videoIdList;
}