package cn.com.duiba.kjy.livecenter.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.guide.GuideVideoVisitorStatsDto;
import cn.com.duiba.kjy.livecenter.api.param.guide.GuideVideoVisitorStatsSearchParam;

import javax.annotation.Nullable;
import java.util.List;

/**
 * 引导视频-用户观看记录
 * @author lizhi
 * @date 2020/11/17 2:23 下午
 */
@AdvancedFeignClient
public interface RemoteGuideVideoVisitorStatsService {

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(GuideVideoVisitorStatsSearchParam param);

    /**
     * 根据访客ID和视频id批量查询
     * @param liveVisitorId 访客ID
     * @param videoIdList 视频Id集合
     * @return 引导视频-用户观看记录集合
     */
    List<GuideVideoVisitorStatsDto> selectByVisitorAndVideoIds(Long liveVisitorId, List<Long> videoIdList);

    /**
     * 根据访客ID和视频id查询
     * @param liveVisitorId 访客ID
     * @param videoId 视频Id
     * @return 引导视频-用户观看记录
     */
    GuideVideoVisitorStatsDto selectByVisitorAndVideoId(Long liveVisitorId, Long videoId);

    /**
     * 根据唯一键查询，如果不存在则新增（liveVisitorId+videoId 唯一）
     * @param dto 用户观看记录
     * @return 引导视频-用户观看记录
     */
    @Nullable
    GuideVideoVisitorStatsDto getOrSaveIfAbsent(GuideVideoVisitorStatsDto dto);

    /**
     * 更新用户观看最大时间点（只有比数据库中值大时会更新）
     * @param liveVisitorId 访客ID
     * @param videoId 视频ID
     * @param watchPoint 用户观看最大时间点，单位秒
     * @return 执行结果
     */
    int updateWatchPoint(Long liveVisitorId, Long videoId, Integer watchPoint);

    /**
     * 更新状态
     * @param liveVisitorId 访客ID
     * @param videoId 视频ID
     * @param watchStatus 观看状态，1-未观看，2-观看中，3-已看完
     * @see cn.com.duiba.kjy.livecenter.api.enums.guide.GuideWatchStatusEnum
     * @return 执行结果
     */
    int updateWatchStatus(Long liveVisitorId, Long videoId, Integer watchStatus);
}
