package cn.com.duiba.kjy.livecenter.api.dto.company;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播公司
 * @author kjj mybatis generator
 * @date 2020-03-28
 */
@Data
public class LiveCompanyDto implements Serializable {

    private static final long serialVersionUID = 15853608937918408L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务方类型
     */
    private int bizType;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司logo
     */
    private String companyLogo;

    /**
     * 公司简介
     */
    private String companyDesc;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 邀请人海报图片
     */
    private String invitationPosterPicUrl;

    /**
     * 线索收集员id  agentId
     */
    private Long clueCollectorId;

    /**
     * 预生成的小程序二维码
     */
    private String mpQrcode;

    /**
     * 直播红包：企业付款到零钱-入账详情
     */
    private String redPacketDesc;


    /**
     * 背景音乐
     */
    private String backgroundMusic;

    /**
     * 直播试用有效期
     */
    private Date authExpiryDate;

    /**
     * 会员版本
     */
    private Integer userVersion;

    /**
     * 公司地址
     */
    private String companyAddress;

    /**
     * 公司电话
     */
    private String companyPhone;

    /**
     * 中奖区域限制，1-不限制，2-只允许配置区域
     * @see cn.com.duiba.kjy.livecenter.api.enums.company.CompanyRegionTypeEnum
     */
    private Integer regionType;

    /**
     * 公司等级：1-总公司，2-分公司，3-支分公司
     * @see cn.com.duiba.kjy.livecenter.api.enums.company.CompanyLevelEnum
     */
    private Integer companyLevel;

    /**
     * 上级直播公司ID
     */
    private Long higherId;

    /**
     * 上级直播公司ID集合，级别从高到低，以英文逗号分隔
     */
    private String higherIds;
}
