package cn.com.duiba.kjy.livecenter.api.dto.guide;

import lombok.Data;

import java.io.Serializable;

/**
 * 引导视频
 * @author kjj mybatis generator 
 * @date 2020-11-17
 */
@Data
public class GuideVideoDto implements Serializable {
     
    private static final long serialVersionUID = 16055835362913887L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 视频类型：1-基础教程，2-高级教程
     * @see cn.com.duiba.kjy.livecenter.api.enums.guide.GuideVideoTypeEnum
     */
    private Integer videoType;

    /**
     * 视频地址
     */
    private String videoUrl;

    /**
     * 视频封面图地址
     */
    private String videoCoverImg;

    /**
     * 标题
     */
    private String videoTitle;

    /**
     * 排序值
     */
    private Integer videoSort;

    /**
     * 备注
     */
    private String videoRemark;

    /**
     * 视频总时长，单位秒
     */
    private Integer videoTime;

    /**
     * 前20个id，以英文逗号分隔
     */
    private String preIds;

    /**
     * 后20个id，以英文逗号分隔
     */
    private String nextIds;
}