package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveAgentQrCodeDto;

import java.util.List;
import java.util.Map;

/**
 * 直播带人二维码rpc服务
 * @author 吴文哲
 * @date 2020-04-11 16:31
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentQrCodeService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 代理人小程序码信息
     */
    LiveAgentQrCodeDto findById(Long id);


    /**
     * 根据直播间id  公司id  代理人id 查询
     * @param liveId
     * @param companyId
     * @param agentId
     * @return
     */
    LiveAgentQrCodeDto getByLiveIdCompanyIdAgentId(Long liveId, Long companyId, Long agentId);

    /**
     * 批量保存
     * @param agentQrCodeDtos
     * @return
     */
    Integer batchSave(List<LiveAgentQrCodeDto> agentQrCodeDtos);

    /**
     * 根据条件查询微信小程序二维码
     * @return
     */
    String findQrCOdeUrl(Long liveId,Long  companyId, Long agentId);

    /**
     * 获取代理人最近一场未结束的直播的 小程序码
     * @param agentId 代理人ID
     * @return 代理人小程序码信息
     */
    LiveAgentQrCodeDto getLastNotEndLiveQrCode(Long agentId);

    /**
     * 重新生成小程序码
     * @param id 主键
     */
    void rebuildQrCode(Long id);

    /**
     * 重新获取二维码
     * @param liveId 直播id
     * @param companyId 公司id
     * @param agentId 代理人id
     * @return 二维码oss地址
     */
    String reGetQrCode(Long liveId, Long companyId, Long agentId);

    /**
     * 批量查询代理人二维码信息
     * @param liveId 直播id
     * @param companyId 公司id
     * @param agentIds 代理人id集合
     * @return key：代理人id value：代理人二维码
     */
    Map<Long, String> findByLiveAndAgentIds(Long liveId, Long companyId, List<Long> agentIds);
}
