package cn.com.duiba.kjy.livecenter.api.remoteservice.liveclue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveclue.LiveClueTemplateDto;
import cn.com.duiba.kjy.livecenter.api.param.liveclue.LiveClueTemplateSaveParam;
import cn.com.duiba.kjy.livecenter.api.param.liveclue.LiveClueTemplateSearchParam;

import java.util.List;

/**
 * 直播线索模板rpc服务
 * @author 吴文哲
 * @date 2020-04-13 14:46
 **/
@AdvancedFeignClient
public interface RemoteLiveClueTemplateService {

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<LiveClueTemplateDto> findByCondition(LiveClueTemplateSearchParam param);

    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer countByCondition(LiveClueTemplateSearchParam param);

    /**
     * 新增线索模板
     * @param saveParam
     * @return
     */
    Integer addTemplate(LiveClueTemplateSaveParam saveParam);

    /**
     * 新增 直播线索模板
     * @param saveParam 直播线索模板参数
     * @return 新增结果
     */
    int addTemplateNew(LiveClueTemplateSaveParam saveParam);

    /**
     * 根据主键查找
     * @param templateId
     * @return
     */
    LiveClueTemplateDto findById(Long templateId);

    /**
     * 直播间绑定线索模板
     * @param templateId
     * @param liveId
     * @return
     */
    Integer liveBindTemplate(Long templateId,Long liveId);

    /**
     * 更新线索模板
     * @param updateDto
     * @return
     */
    Integer updateTemplate(LiveClueTemplateDto updateDto);

    /**
     * 模板id
     * @param templateId
     * @return
     */
    Integer deleteTemplate(Long templateId);

    /**
     * 查找系统默认模板
     * @return 系统默认模版
     */
    LiveClueTemplateDto findSystemTemplate();

    /**
     * 根据直播间id 查询
     * 如果找不到会返回 系统默认模板
     * @param liveId
     * @return
     */
    LiveClueTemplateDto findByLiveId(Long liveId);
}
