package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveAppointmentDto;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveUserAppointmentSubDto;

/**
 * 用户预约服务
 * @author zhanghuifeng
 * date 2020/4/5-11:56 上午
 */
@AdvancedFeignClient
public interface RemoteLiveUserAppointmentService {


    /**
     * 直播间预约
     *
     * @param dto 直播间预约参数
     * @return true-预约成功，false-预约失败
     */
    boolean liveAppointment(LiveAppointmentDto dto);

    /**
     * 直播间预约关注 会记录预约推送信息
     *
     * @param dto 直播间预约参数
     * @return true-预约成功，false-预约失败
     */
    boolean liveAppointmentSubscribe(LiveUserAppointmentSubDto dto);

}
