package cn.com.duiba.kjy.livecenter.api.constant;

import lombok.Data;

/**
 * @author lizhi
 * @date 2020/3/28 11:31 AM
 */
@Data
public class RocketMqTagConstant {

    private RocketMqTagConstant() {}

    /**
     * 直播企业付款到零钱结果
     */
    public static final String PAY_WX_COMPANY_RESULT = "WX_COM_LIVE";

    /**
     * 批量发送评论
     */
    public static final String BATCH_SEND_SPOKE_MSG = "BATCH_SEND_SPOKE_MSG";

    /**
     * web socket 直播推送消息
     */
    public static final String WS_LIVE_SEND_MSG = "WS_LIVE_SEND_MSG";

    /**
     * web socket 直播批量推送消息
     * @deprecated 拆分成个人和全部推送
     */
    @Deprecated
    public static final String WS_LIVE_BATCH_SEND_MSG = "WS_LIVE_BATCH_SEND_MSG";

    /**
     * web socket 直播给所有人推送消息
     */
    public static final String WS_LIVE_PUSH_ALL_SEND_MSG = "WS_LIVE_PUSH_ALL_SEND_MSG";

    /**
     * web socket 直播给指定用户推送消息
     */
    public static final String WS_LIVE_PERSONAL_PUSH_SEND_MSG = "WS_LIVE_PERSONAL_PUSH_SEND_MSG";

    /**
     * 红包助力完成
     */
    public static final String LIVE_RED_PACKET_HELP = "LIVE_RED_PACKET_HELP";

    /**
     * 红包已领完
     */
    public static final String LIVE_RED_PACKET_RECEIVE_END = "LIVE_RED_PACKET_RECEIVE_END";

    /**
     * 红包开始收集用户信息
     */
    public static final String LIVE_RED_COLLECT = "LIVE_RED_COLLECT";

    /**
     * 红包开始计算
     */
    public static final String LIVE_RED_COMPUTE = "LIVE_RED_COMPUTE";

    /**
     * 红包停止领取
     */
    public static final String LIVE_RED_STOP_RECEIVE = "LIVE_RED_STOP_RECEIVE";

    /**
     * 红包补马甲结束
     */
    public static final String LIVE_RED_ADD_VEST_AND_END = "LIVE_RED_ADD_VEST_AND_END";

    /**
     * 答题红包停止领取
     */
    public static final String LIVE_QUESTION_RED_STOP_RECEIVE = "LIVE_QUESTION_RED_STOP_RECEIVE";


    /**
     * 访客领取红包-发往kjy-web
     * @deprecated 原有流程废弃，见 LIVE_RED_DRAW
     */
    @Deprecated
    public static final String LIVE_RED_DRAW_TO_KJY_WEB = "LIVE_RED_DRAW_TO_KJY_WEB";

    /**
     * 访客领取红包
     */
    public static final String LIVE_RED_DRAW = "LIVE_RED_DRAW";


    /**
     * 抽奖福利，开始计算
     */
    public static final String LIVE_WELFARE_START_COMPUTE = "LIVE_WELFARE_START_COMPUTE";

    /**
     * 预约权益领取推送
     */
    public static final String LIVE_USER_DRAW_WELFARE = "LIVE_USER_DRAW_WELFARE";

    /**
     * 直播间爆款福利定时推送
     */
    public static final String LIVE_BOOM_WELFARE_PUSH = "LIVE_BOOM_WELFARE_PUSH";

    /**
     * 直播预生成 小程序二维码
     */
    public static final String LIVE_PRE_BUILD_MP_QRCODE = "LIVE_PRE_BUILD_MP_QRCODE";

    /**
     * 直播批量预生成小程序二维码，逻辑与LIVE_PRE_BUILD_MP_QRCODE一致，从单条变成多条
     */
    public static final String LIVE_PRE_BUILD_MP_QRCODE_BATCH = "LIVE_PRE_BUILD_MP_QRCODE_BATCH";

    /**
     * 直播批量预生成代理人 小程序二维码
     */
    public static final String LIVE_BATCH_PRE_BUILD_MP_QRCODE = "LIVE_BATCH_PRE_BUILD_MP_QRCODE";



    /**
     * 直播结束，数据统计完成后发送消息通知代理人
     */
    public static final String LIVE_END_SEND_STATISTICS = "LIVE_END_SEND_STATISTICS";

    /**
     * 直播结束，直播用户成为代理人客户
     */
    public static final String LIVE_USER_BEING_SELLER_CUSTOMER = "LIVE_USER_BEING_SELLER_CUSTOMER";

    /**
     * 直播咨询代理人自动回复
     */
    public static final String LIVE_ADVICE_AUTO_REPLY_CUSTOMER = "LIVE_ADVICE_AUTO_REPLY_CUSTOMER";

    /**
     * 直播前抽奖推送
     */
    public static final String LIVE_PRE_LOTTERY_PUSH = "LIVE_PRE_LOTTERY_PUSH";

    /**
     * 直播前抽奖
     */
    public static final String LIVE_PRE_LOTTERY_DRAW = "LIVE_PRE_LOTTERY_DRAW";

    /**
     * 直播中抽奖任务回调
     */
    public static final String LIVE_LOTTERY_DRAW = "LIVE_LOTTERY_DRAW";

    /**
     * 直播中开奖推送
     */
    public static final String LIVE_ING_DRAW_AWARD_PUSH = "LIVE_ING_DRAW_AWARD_PUSH";

    /**
     * 直播黑名单源头任务
     */
    public static final String LIVE_BLACK_SOURCE_TASK = "LIVE_BLACK_SOURCE_TASK";

    /**
     * 直播指定中奖 收款二维码配置校验
     */
    public static final String LIVE_SPECIFY_AWARD_PAY_CODE_VALIDATE_TAG = "LIVE_SPECIFY_AWARD_PAY_CODE_VALIDATE_TAG";

    /**
     * 直播指定中奖 直播结束后30分钟推送
     */
    public static final String LIVE_SPECIFY_AWARD_PAY_CODE_PUSH_TAG = "LIVE_SPECIFY_AWARD_PAY_CODE_PUSH_TAG";

    /**
     * 直播指定中奖 直播结束后35分钟后 校验推送状态
     */
    public static final String LIVE_SPECIFY_AWARD_PUSH_STATUS_VALIDATE_TAG = "LIVE_SPECIFY_AWARD_PUSH_STATUS_VALIDATE_TAG";

    /**
     * 代理人推送数据同步
     */
    public static final String SELLER_PUSH_DATA_SYNC = "SELLER_PUSH_DATA_SYNC";

    /**
     * h5分享之后 绑定关系tag
     */
    public static final String LIVE_H5_SHARE_BINDING_TAG = "LIVE_H5_SHARE_BINDING_TAG";

    /**
     * 直播团队平均邀请/到场统计tag
     */
    public static final String LIVE_TEAM_AVG_STATISTIC_TAG = "LIVE_TEAM_AVG_STATISTIC_TAG";

    /**
     * 修复邀请关系tag
     */
    public static final String FIX_INVITATION_RELATION_TAG = "FIX_INVITATION_RELATION_TAG";

    /**
     * 处理访客是否成为直播代理人Tag taskcenter处理
     */
    public static final String LIVE_VISITOR_BE_LIVE_AGENT_TAG = "LIVE_VISITOR_BE_LIVE_AGENT_TAG";

    /**
     * 直播小程序用户风险评分tag
     */
    public static final String LIVE_MP_RISK_RANK_TAG = "LIVE_MP_RISK_RANK_TAG";

    /**
     * 直播结束 统计完成后 通知taskcenter开始统计合作方线索数据
     */
    public static final String LIVE_END_CLUE_OPEN_STAT_TAG = "LIVE_END_CLUE_OPEN_STAT_TAG";

    /**
     * 直播榜单排行任务tag
     */
    public static final String LIVE_RANK_JOB_TAG = "LIVE_RANK_JOB_TAG";

    /**
     * 必要时异步修复邀请关系
     */
    public static final String LIVE_ASYNC_FIX_INVITATION_RELATION = "LIVE_ASYNC_FIX_INVITATION_RELATION";

    /**
     * 初始化直播统计数据(创建直播时,初始化代理人/团队统计数据)
     */
    public static final String INIT_LIVE_STATISTIC_DATA = "INIT_LIVE_STATISTIC_DATA";

    /**
     * 第一次绑定关系成功
     */
    public static final String LIVE_FIRST_BINDING_SUCCESS = "LIVE_FIRST_BINDING_SUCCESS";

    /**
     * 发放抽奖码tag
     */
    public static final String LIVE_LOTTERY_CODE_TAG = "LIVE_LOTTERY_CODE_TAG";

}
