package cn.com.duiba.kjy.livecenter.api.remoteservice.open;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.open.LiveClueOpenStatDto;

import java.util.List;

/**
 * 直播线索统计-合作方直播统计
 * @author kjj mybatis generator 
 * @date 2020-12-25
 */
@AdvancedFeignClient
public interface RemoteLiveClueOpenStatService {

    /**
     * 根据公司id和日期查询直播信息
     *
     * @param companyId 总公司id
     * @param startDate 开始日期
     * @param endDate 结束日期
     * @return 直播信息
     */
    List<LiveClueOpenStatDto> selectByCompanyIdAndDate(Long companyId, String startDate, String endDate);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播线索统计-合作方直播统计
     */
    LiveClueOpenStatDto selectById(Long id);

    /**
     * 新增
     * @param entity 直播线索统计-合作方直播统计
     * @return 主键id
     */
    Long insertGeneratedKeys(LiveClueOpenStatDto entity);

    /**
     * 更新
     * @param entity 直播线索统计-合作方直播统计
     * @return 执行结果
     */
    int update(LiveClueOpenStatDto entity);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}