package cn.com.duiba.kjy.livecenter.api.enums.live.feedback;

/**
 * @author: linjianhui
 * @date: 2021/1/4 16:17
 * @description:  反馈管理处理状态
 */
public enum FeedbackProcessStatusEnum {
    /**
     * 处理状态 1:未处理，2:处理中，3:已处理，4:特殊处理
     */
    START_PROCESS(1,"未处理"),
    INIT_PROCESS(2,"处理中"),
    DONE_PROCESS(3,"已处理"),
    SPECIAL_PROCESS(4,"特殊处理"),
    ;

    private Integer status;

    private String desc;

    FeedbackProcessStatusEnum(Integer status,String desc){
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
