package cn.com.duiba.kjy.livecenter.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveRedUseQuotaStatDto;
import cn.com.duiba.live.conf.service.api.dto.red.LiveConfRedPacketDto;

import java.util.List;

/**
 * 红包配置相关
 * @author lizhi
 * @date 2021/6/22 5:04 下午
 */
@AdvancedFeignClient
public interface RemoteLiveConfRedPacketService {

    /**
     * 获取本场直播已使用的额度，查询本场直播所有红包，代码计算
     * 总金额-已结束红包的剩余金额
     * @param liveId 直播ID
     * @return 已使用的额度
     */
    LiveRedUseQuotaStatDto useQuotaByLiveId(Long liveId);

    /**
     * 计算传入的红包列表，已使用的额度
     * 总金额-已结束红包的剩余金额
     * @param liveId 直播ID，用于打印日志
     * @param list 红包列表
     * @return 已使用的额度
     */
    LiveRedUseQuotaStatDto useQuotaByList(Long liveId, List<LiveConfRedPacketDto> list);
}
