package cn.com.duiba.kjy.livecenter.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveRedDrawDto;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveRedDrawResultDto;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveRedDrawTicketDto;

import java.util.List;
import java.util.Map;

/**
 * 红包抽奖服务
 * @author lizhi
 * @date 2020/6/19 11:40 AM
 */
@AdvancedFeignClient
public interface RemoteLiveRedDrawService {

    /**
     * 获取缓存中的手气王凭证
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 手气王凭证，缓存中不存在则返回null
     */
    List<LiveRedDrawTicketDto> getLuckRedTicketList(Long liveId, Long confId);

    /**
     * 获取缓存中的普通红包凭证集合
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 普通红包凭证，缓存中不存在则返回null
     */
    List<LiveRedDrawTicketDto> getGeneralRedTicketList(Long liveId, Long confId);

    /**
     * 设置手气王红包凭证
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param luckRedList 手气王凭证
     */
    void setLuckRedTicketList(Long liveId, Long confId, List<LiveRedDrawTicketDto> luckRedList);

    /**
     * 设置普通红包凭证
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param generalRedList 普通红包凭证
     */
    void setGeneralRedTicketList(Long liveId, Long confId, List<LiveRedDrawTicketDto> generalRedList);

    /**
     * 清除所有的凭证
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void clearRedTicketList(Long liveId, Long confId);


    /**
     * 获取缓存中的手气王中奖人员
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 手气王中奖人集合
     */
    List<LiveRedDrawDto> getLuckRedList(Long liveId, Long confId);

    /**
     * 获取缓存中的普通红包中奖人员
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 普通红包中奖人集合
     */
    List<LiveRedDrawDto> getGeneralRedList(Long liveId, Long confId);

    /**
     * 新增或修改领取结果
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param bizUserId 业务方用户ID
     * @param resultDto 领取结果
     * @deprecated redis的key改为 直播用户ID，不再保留rpc，改为mq交互
     */
    @Deprecated
    void setReceiveResult(Long liveId, Long confId, String bizUserId, LiveRedDrawResultDto resultDto);

    /**
     * 添加手气王红包中奖人员
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param luckRed 手气王中奖人员
     */
    void addLuckRed(Long liveId, Long confId, LiveRedDrawDto luckRed);

    /**
     * 添加普通红包中奖人员
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param generalRed 普通红包中奖人员
     */
    void addGeneralRed(Long liveId, Long confId, LiveRedDrawDto generalRed);

    /**
     * 查询用户领取结果，若没有领取过，则返回null
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param bizUserId 业务方用户ID
     * @return 领取结果
     * @deprecated redis的key改为 直播用户ID，见下面方法
     */
    @Deprecated
    LiveRedDrawResultDto getReceiveResult(Long liveId, Long confId, String bizUserId);

    /**
     * 查询用户领取结果，若没有领取过，则返回null
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param liveUserId 直播用户ID
     * @return 领取结果
     */
    LiveRedDrawResultDto getReceiveResultNew(Long liveId, Long confId, Long liveUserId);

    /**
     * 批量查询用户领取结果
     * @param liveId 直播ID
     * @param confIdList 红包ID集合
     * @param bizUserId 业务方用户ID
     * @return key：红包ID， value：领取结果，若没有领取过，则为null
     * @deprecated redis的key改为 直播用户ID，见下面方法
     */
    @Deprecated
    Map<Long, LiveRedDrawResultDto> multiGetReceiveResult(Long liveId, List<Long> confIdList, String bizUserId);

    /**
     * 批量查询用户领取结果
     * @param liveId 直播ID
     * @param confIdList 红包ID集合
     * @param liveUserId 直播用户ID
     * @return key：红包ID， value：领取结果，若没有领取过，则为null
     */
    Map<Long, LiveRedDrawResultDto> multiGetReceiveResultNew(Long liveId, List<Long> confIdList, Long liveUserId);
}
